<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Defines names of plugin types and some strings used at the plugin managment
 *
 * @package    core
 * @subpackage plugin
 * @copyright  2011 David Mudrak <david@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Actions';
$string['availability'] = 'Availability';
$string['checkforupdates'] = 'Check for available updates';
$string['checkforupdateslast'] = 'Last check done on {$a}';
$string['displayname'] = 'Plugin name';
$string['moodleversion'] = 'Moodle {$a}';
$string['nonehighlighted'] = 'No plugins require your attention now';
$string['nonehighlightedinfo'] = 'Display the list of all installed plugins anyway';
$string['noneinstalled'] = 'No plugins of this type are installed';
$string['notes'] = 'Notes';
$string['numtotal'] = 'Installed: {$a}';
$string['numdisabled'] = 'Disabled: {$a}';
$string['numextension'] = 'Contributions: {$a}';
$string['numupdatable'] = 'Updates available: {$a}';
$string['otherplugin'] = '{$a->component}';
$string['otherpluginversion'] = '{$a->component} ({$a->version})';
$string['showall'] = 'Reload and show all plugins';
$string['pluginchecknotice'] = 'This page displays plugins that may require your attention during the upgrade. Highlighted items include new plugins that are about to be installed, updated plugins that are about to be upgraded and any missing plugins. Contributed plugins are also highlighted.
It is recommended that you check whether there are more recent versions of contributed plugins available and update their source code before continuing with this Moodle upgrade.';
$string['plugindisable'] = 'Disable';
$string['plugindisabled'] = 'Disabled';
$string['pluginenable'] = 'Enable';
$string['pluginenabled'] = 'Enabled';
$string['requiredby'] = 'Required by: {$a}';
$string['requires'] = 'Requires';
$string['rootdir'] = 'Directory';
$string['settings'] = 'Settings';
$string['somehighlighted'] = 'Number of plugins requiring your attention: {$a}';
$string['somehighlightedinfo'] = 'Display the full list of installed plugins';
$string['somehighlightedonly'] = 'Display only plugins requiring your attention';
$string['source'] = 'Source';
$string['sourceext'] = 'Contributed';
$string['sourcestd'] = 'Standard';
$string['status'] = 'Status';
$string['status_delete'] = 'To be deleted';
$string['status_downgrade'] = 'Higher version already installed!';
$string['status_missing'] = 'Missing from disk!';
$string['status_new'] = 'To be installed';
$string['status_nodb'] = 'No database';
$string['status_upgrade'] = 'To be upgraded';
$string['status_uptodate'] = 'Installed';
$string['systemname'] = 'Identifier';
$string['type_auth'] = 'Authentication method';
$string['type_auth_plural'] = 'Authentication methods';
$string['type_block'] = 'Block';
$string['type_block_plural'] = 'Blocks';
$string['type_coursereport'] = 'Course report';
$string['type_coursereport_plural'] = 'Course reports';
$string['type_editor'] = 'Editor';
$string['type_editor_plural'] = 'Editors';
$string['type_enrol'] = 'Enrolment method';
$string['type_enrol_plural'] = 'Enrolment methods';
$string['type_filter'] = 'Text filter';
$string['type_filter_plural'] = 'Text filters';
$string['type_format'] = 'Course format';
$string['type_format_plural'] = 'Course formats';
$string['type_gradeexport'] = 'Grade export method';
$string['type_gradeexport_plural'] = 'Grade export methods';
$string['type_gradeimport'] = 'Grade import method';
$string['type_gradeimport_plural'] = 'Grade import methods';
$string['type_gradereport'] = 'Gradebook report';
$string['type_gradereport_plural'] = 'Gradebook reports';
$string['type_gradingform'] = 'Advanced grading method';
$string['type_gradingform_plural'] = 'Advanced grading methods';
$string['type_local'] = 'Local plugin';
$string['type_local_plural'] = 'Local plugins';
$string['type_message'] = 'Messaging output';
$string['type_message_plural'] = 'Messaging outputs';
$string['type_mnetservice'] = 'MNet service';
$string['type_mnetservice_plural'] = 'MNet services';
$string['type_mod'] = 'Activity module';
$string['type_mod_plural'] = 'Activity modules';
$string['type_plagiarism'] = 'Plagiarism prevention plugin';
$string['type_plagiarism_plural'] = 'Plagiarism prevention plugins';
$string['type_portfolio'] = 'Portfolio';
$string['type_portfolio_plural'] = 'Portfolios';
$string['type_profilefield'] = 'Profile field type';
$string['type_profilefield_plural'] = 'Profile field types';
$string['type_qbehaviour'] = 'Question behaviour';
$string['type_qbehaviour_plural'] = 'Question behaviours';
$string['type_qformat'] = 'Question import/export format';
$string['type_qformat_plural'] = 'Question import/export formats';
$string['type_qtype'] = 'Question type';
$string['type_qtype_plural'] = 'Question types';
$string['type_report'] = 'Site report';
$string['type_report_plural'] = 'Reports';
$string['type_repository'] = 'Repository';
$string['type_repository_plural'] = 'Repositories';
$string['type_theme'] = 'Theme';
$string['type_theme_plural'] = 'Themes';
$string['type_tool'] = 'Admin tool';
$string['type_tool_plural'] = 'Admin tools';
$string['type_webservice'] = 'Webservice protocol';
$string['type_webservice_plural'] = 'Webservice protocols';
$string['updateavailable'] = 'There is a new version {$a} available!';
$string['updateavailable_moreinfo'] = 'More info...';
$string['updateavailable_release'] = 'Release {$a}';
$string['uninstall'] = 'Uninstall';
$string['version'] = 'Version';
$string['versiondb'] = 'Current version';
$string['versiondisk'] = 'New version';
