﻿// Regex variables
var regSpace = /\s/;   // space
var nonChars=/[^a-zA-Z]/	//Non A-Z nor a-z
var numericalData = /(^-?\d\d*\.?\d\d*$)/; 	// -ve or +ve num with optional decimal
var invalidChars = /[-_()&+*\"\'@!\%\/?:=~#\\^]/ 	// Invalid chars 
var validPhone = /^[2-9][0-8][0-9][2-9][0-9][0-9][0-9]{4}$/
var onlyDigits = /^\d*$/;   // only digits are allowed in the string

// Function to test for only characters in a passed string	  Param: String
function hasOnlyCharacters(strText){
  return !nonChars.test(strText);
}

// Function to test for only numbers in a passed string       Param: String
function hasOnlyNumbers(strText) {
  return onlyDigits.test(strText);
}

function ge(id) {
  var ctrl = document.getElementById(id);
  if (ctrl) {
    return ctrl;
  }
  return null;
}

function exists(id) {
  var ctrl = document.getElementById(id);
  if (ctrl) {
    return true;
  }
  return false;
}

function Hide(id) {
  if (exists(id)) {
    ge(id).style.display = "none";
  }
}

function Show(id) {
  if (exists(id)) {
    ge(id).style.display = "";
  }
}

function DisableCtrl(id) {
  if (exists(id)) {
    ge(id).disabled = true;
  }
}

function EnableCtrl(id) {
  if (exists(id)) {
    ge(id).disabled = false;
  }
}

function ClearText(id) {
  if (exists(id)) {
    ge(id).value = "";
  }
}

function ShowErr(id) {
  if (exists(id)) {
    ge(id).style.border = "3px solid #D98C40";
  }
}

function ClearErr(id) {
  if (exists(id)) {
    ge(id).style.border = "0px";
  }
}
