
function checkRememberMe(rememberMeFrm, domain) {
	if ((document.getElementById("usr_remember_me_input")) && document.getElementById("usr_remember_me_input").type == "checkbox") {
		if (document.getElementById("usr_remember_me_input").checked == true)
			document.cookie = "_tmprememberme=1; domain=" + domain + "; path=/; secure";
		else
			document.cookie = "_tmprememberme=0; domain=" + domain + "; path=/; secure";
	}
}

function selectUser(userNameFrm)
{
	var selectedValue = userNameFrm.usr_remember_me_input.options[userNameFrm.usr_remember_me_input.selectedIndex].value;
	if(selectedValue > "0")
		userNameFrm.UserID.value = selectedValue;
}


function check_all_fields_logon(userId, pwd)
{
	var username = userId.value.toLowerCase();
	var password = pwd.value.toLowerCase();
	if ( (username.length<1) || (password.length<1) )
	{
		if((username.length<1))
		{
			alert("Error Message LO001:\nPlease enter both your User ID and Password.");
			userId.focus();
		}
		else 
		{
			alert("Error Message LO001:\nPlease enter both your User ID and Password.");
			pwd.focus();
		}
		return false;
	}
	//else if ( !checkInputUserId(username) || !checkInputPassword(password) )
	else if ( !checkInputUserId(username) )
	{
		alert("Error Message LO011:\nThe User ID and/or Password you entered is not valid.\nYour User ID and Password must consist only of letters and numbers.");
		pwd.focus();
		return false;
	}
	document.getElementById("UserID").value = userId.value.toLowerCase();
	document.Started.auth_passwd_org.value = pwd.value;
	document.getElementById("Password").value = pwd.value.toLowerCase();
  return true;
}

function checkInputPassword (formValue)
{
	var alphaNumericStr = " ";
	retVal = true;
	for (i=0;i<formValue.length;i++)
	{
	      if ((alphaNumericStr.indexOf( formValue.substring(i,i+1).toLowerCase() ) >= 0))
	      {
				retVal = false;
	      }
	}
	return retVal;
}
function checkInputUserId (formValue)
{
	var alphaNumericStr = "abcdefghijklmnopqrstuvwxyz0123456789_";
	retVal = true;
	for (i=0;i<formValue.length;i++)
	{
	     if (!(alphaNumericStr.indexOf( formValue.substring(i,i+1).toLowerCase() ) >= 0))
	    {
			retVal = false;
	    }
	}
	return retVal;
}

function checkInputToken (formValue)
{
	var numericStr = "0123456789";
	
	for (i=0;i<formValue.length;i++)
	{
	     if (!(numericStr.indexOf( formValue.substring(i,i+1) ) >= 0))
	    {
			return false;
	    }
	}
	return true;
}

function check_if_token_user() {
    var token = document.getElementById("Token");
    var nexttoken = document.getElementById("NextToken");
    if ((token != null) && (token.offsetHeight != 0 && token.offsetWidth != 0)) {
        return true;
    }
    else if ((token != null) && (nexttoken != null)) {
        return true;
    }
    else {
        return false;
    }
}

function check_if_next_token_scenario() {
    if (check_if_token_user()) {
        var token = document.getElementById("Token");
        var nexttoken = document.getElementById("NextToken");
        if ((token != null) && (nexttoken != null)) {
            return true;
        }
    }
    return false;
}

function check_all_fields_logon_RSA(userId, pwd) {
    var username = userId.value.toLowerCase();
    var password = pwd.value.toLowerCase();
    var istoken = check_if_token_user();
    var isnexttokenscenario = check_if_next_token_scenario();
    var token = document.getElementById("Token");
    var nexttoken = document.getElementById("NextToken");

    var reqmsg = "Error Message LO111:\nPlease enter both your User ID and Password.";
    var validationmsg = "Error Message LO112:\nThe User ID and/or Password you entered is not valid.\nYour User ID and Password must consist only of letters and numbers.";

    if (isnexttokenscenario) {
        reqmsg = "Error Message LO113:\nPlease enter your User ID, Password and Token codes as described.";
    }

    if (istoken) {
        validationmsg = "Error Message LO114:\nThe User ID, Password, and/or token you entered is not valid.\nYour User ID and Password must consist only of letters and numbers.\nYour token must consist only of numbers.";
    }
    if (username.length < 1) {
        alert(reqmsg);
        userId.focus();
        return false;
    }
    if (password.length < 1) {
        alert(reqmsg);
        pwd.focus();
        return false;
    }
    if (isnexttokenscenario)// The token code is required only in the scenarios where next token code is required. 
    {
        if (token.value.length < 1) {
            alert(reqmsg);
            token.focus();
            return false;
        }
        if (nexttoken.value.length < 1) {
            alert(reqmsg);
            nexttoken.focus();
            return false;
        }
    }
    if (!checkInputUserId(username)) {
        alert(validationmsg);
        userId.focus();
        return false;
    }
    if (istoken) {
        if (!checkInputToken(token.value)) {
            alert(validationmsg);
            token.focus();
            return false;
        }
    }

    if (isnexttokenscenario) {
        if (!checkInputToken(nexttoken.value)) {
            alert(validationmsg);
            nexttoken.focus();
            return false;
        }
    }

    if ((istoken && token.value.length > 0) || (isnexttokenscenario)) {
      setSiteId(true);
      document.getElementById("auth_tokencode").value = token.value;
      document.cookie = "_tmprsauser=1;secure";
      if (isnexttokenscenario) {
        document.getElementById("auth_nexttokencode").value = nexttoken.value;
      }
    } else {
      setSiteId(false);
      document.cookie = "_tmprsauser=0;secure";
    }

    document.getElementById("UserID").value = userId.value.toLowerCase();
    document.Started.auth_passwd_org.value = pwd.value;
    document.getElementById("Password").value = pwd.value.toLowerCase();
    return true;
  }


  function setSiteId(useToken) {
    var siteIdField = document.getElementById("auth_siteId");
    var currentSiteId = siteIdField.value;
    switch (currentSiteId) {
      case "COL":
      case "CCR":
        siteIdField.value = useToken ? "CCR" : "COL";
        break;
      case "WMS":
      case "WMR":
        siteIdField.value = useToken ? "WMR" : "WMS";
      break;
    default:
      break;
    }
  }